/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.biomes;

import java.util.ArrayList;
import java.util.List;
import paulevs.betternether.biomes.NetherBiome;
import paulevs.betternether.biomes.NetherBiomeGravelDesert;
import paulevs.betternether.biomes.NetherBiomeJungle;
import paulevs.betternether.biomes.NetherBoneReef;
import paulevs.betternether.biomes.NetherGrasslands;
import paulevs.betternether.biomes.NetherMushroomForest;
import paulevs.betternether.biomes.NetherMushroomForestEdge;
import paulevs.betternether.biomes.NetherPoorGrasslands;
import paulevs.betternether.biomes.NetherWartForest;
import paulevs.betternether.biomes.NetherWartForestEdge;
import paulevs.betternether.config.ConfigLoader;

public class BiomeRegister {
    public static int biomeCount;
    public static NetherBiome[] BiomeRegistry;
    public static NetherBiome BIOME_EMPTY_NETHER;
    public static NetherBiome BIOME_GRAVEL_DESERT;
    public static NetherBiome BIOME_NETHER_JUNGLE;
    public static NetherBiome BIOME_WART_FOREST;
    public static NetherBiome BIOME_GRASSLANDS;
    public static NetherBiome BIOME_MUSHROOM_FOREST;
    public static NetherBiome BIOME_MUSHROOM_FOREST_EDGE;
    public static NetherBiome BIOME_WART_FOREST_EDGE;
    public static NetherBiome BIOME_BONE_REEF;
    public static NetherBiome BIOME_POOR_GRASSLANDS;

    public static void registerBiomes() {
        ArrayList<NetherBiome> biomes = new ArrayList<NetherBiome>();
        BIOME_EMPTY_NETHER = BiomeRegister.registerBiome(new NetherBiome("Empty Nether"), biomes);
        BIOME_GRAVEL_DESERT = BiomeRegister.registerBiome(new NetherBiomeGravelDesert("Gravel Desert"), biomes);
        BIOME_NETHER_JUNGLE = BiomeRegister.registerBiome(new NetherBiomeJungle("Nether Jungle"), biomes);
        BIOME_WART_FOREST = BiomeRegister.registerBiome(new NetherWartForest("Wart Forest"), biomes);
        BIOME_GRASSLANDS = BiomeRegister.registerBiome(new NetherGrasslands("Nether Grasslands"), biomes);
        BIOME_MUSHROOM_FOREST = BiomeRegister.registerBiome(new NetherMushroomForest("Nether Mushroom Forest"), biomes);
        BIOME_MUSHROOM_FOREST_EDGE = BiomeRegister.registerEdgeBiome(new NetherMushroomForestEdge("Nether Mushroom Forest Edge"), BIOME_MUSHROOM_FOREST, 10);
        BIOME_WART_FOREST_EDGE = BiomeRegister.registerEdgeBiome(new NetherWartForestEdge("Nether Wart Forest Edge"), BIOME_WART_FOREST, 9);
        BIOME_BONE_REEF = BiomeRegister.registerSubBiome(new NetherBoneReef("Bone Reef"), BIOME_GRASSLANDS);
        BIOME_POOR_GRASSLANDS = BiomeRegister.registerSubBiome(new NetherPoorGrasslands("Poor Nether Grasslands"), BIOME_GRASSLANDS);
        biomeCount = biomes.size();
        BiomeRegistry = new NetherBiome[biomeCount];
        for (int i = 0; i < biomeCount; ++i) {
            BiomeRegister.BiomeRegistry[i] = (NetherBiome)biomes.get(i);
        }
    }

    private static NetherBiome registerBiome(NetherBiome biome, List<NetherBiome> biomes) {
        if (ConfigLoader.mustInitBiome()) {
            biomes.add(biome);
            return biome;
        }
        return null;
    }

    private static NetherBiome registerEdgeBiome(NetherBiome biome, NetherBiome mainBiome, int size) {
        if (ConfigLoader.mustInitBiome() && mainBiome != null) {
            mainBiome.setEdge(biome);
            mainBiome.setEdgeSize(size);
            return biome;
        }
        return null;
    }

    private static NetherBiome registerSubBiome(NetherBiome biome, NetherBiome mainBiome) {
        if (ConfigLoader.mustInitBiome() && mainBiome != null) {
            mainBiome.addSubBiome(biome);
            return biome;
        }
        return null;
    }

    public static NetherBiome getBiomeID(int id) {
        return BiomeRegistry[id];
    }

    public static NetherBiome[] getBiomes() {
        return BiomeRegistry;
    }
}

